﻿<%@ Page Language="c#" CodePage="1200" AutoEventWireup="false" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">
    
    static Soneta.Handel.DokumentyParams dParams;

    [Context]
    static public Soneta.Handel.DokumentyParams DParams {
        get { return dParams; }
        set { dParams = value; }
    }
    
    protected void dc_ContextLoad(object sender, EventArgs e) {
        ReportHeader.Title += "Typ: <STRONG>" + Soneta.HTML.HtmlParser.HtmlEncode(DParams.FiltrTypu.ToString());
        bool uwzględniajUsługi = false;
        colSumaBezDup.Visible = uwzględniajUsługi;
        colSumaTowProd.Visible = !uwzględniajUsługi;
    }

</script>

<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Obroty wg dokumentów</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<body>
		<form id="raport" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Obroty wg dokumentów|</STRONG>Kierunek:<STRONG> {0}|</STRONG>Magazyn:<STRONG> {1}, </STRONG>Okres:<STRONG> {2}|</STRONG>Definicja:<STRONG> {3}, </STRONG>Seria:<STRONG> {4}, </STRONG>|Partia:<STRONG> {5}, </STRONG>"
				runat="server" DataMember0="DokumentyParams.Kierunek" DataMember1="DokumentyParams.Magazyn" DataMember2="DokumentyParams.OkresDat"
				DataMember3="DokumentyParams.Definicja"  DataMember4="DokumentyParams.Seria" DataMember5="DokumentyParams.FiltrTypuPartii"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Left" DataMember="Data" Caption="Magazynowy~Data" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="16" Align="Left" DataMember="Numer" Caption="Magazynowy~Numer" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="16" DataMember="DokumentHandlowyNumer" Caption="Handlowy|Numer" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Kontrahent" Total="Info" Caption="Kontrahent" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn ID="colSumaBezDup" Width="11" Align="Right" DataMember="SumaBezDup.Netto" Total="Sum" Caption="Wartość~Dokumentu"
						HideZero="True" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn ID="colSumaTowProd" Width="11" Align="Right" DataMember="SumaPozycjiTowProd.Netto" Total="Sum" Caption="Wartość~Dokumentu"
						HideZero="True" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>						
					<ea:GridColumn Width="11" Align="Right" DataMember="Workers.ObrotyDokumentu.WartośćZakupu" Total="Sum"
						Caption="Wartość~Zakupu" HideZero="True" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="Workers.ObrotyDokumentu.DoRozliczania" Total="Sum"
						Caption="Wartość~Do rozlicz." HideZero="True" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="11" Align="Right" DataMember="Workers.ObrotyDokumentu.Marża" Total="Sum"
						Caption="Marża~Wartość" HideZero="True" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="8" Align="Right" DataMember="Workers.ObrotyDokumentu.MarżaProcent" Caption="Marża~%"
						HideZero="True" runat="server" EncodeHTML="True"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</html>

